# This files contains your custom actions which can be used to run
# custom Python code.
#
# See this guide on how to implement these action:
# https://rasa.com/docs/rasa/core/actions/#custom-actions/


# This is a simple example for a custom action which utters "Hello World!"

from typing import Any, Text, Dict, List, Union, Optional

from rasa_sdk.forms import FormAction, REQUESTED_SLOT
from rasa_sdk import Action, Tracker
from rasa_sdk.executor import CollectingDispatcher


class NumberForm(FormAction):

    def name(self):
        """Request Number action"""
        return "number_form"

    def validate_number(
            self,
            value: Text,
            dispatcher: CollectingDispatcher,
            tracker: Tracker,
            domain: Dict[Text, Any],
        ) -> Optional[Text]:
        return {"number": value}

    def validate_item(
            self,
            value: Text,
            dispatcher: CollectingDispatcher,
            tracker: Tracker,
            domain: Dict[Text, Any],
        ) -> Optional[Text]:
        return {"item": value}

    @staticmethod
    def required_slots(tracker):

        return ["item", "number"]

    def slot_mappings(self) -> Dict[Text, Union[Dict, List[Dict]]]:
        """A dictionary to map required slots to
            - an extracted entity
            - intent: value pairs
            - a whole message
            or a list of them, where a first match will be picked"""

        return {
            "number": [self.from_entity(entity='number')],
            "item": [self.from_entity(entity='item')]
        }

    def submit(self, dispatcher, tracker, domain):
        inputItem = tracker.get_slot("item")

        inputNum = tracker.get_slot("number")

        message = "##### current slot:item={},number={}".format(inputItem, inputNum)
        dispatcher.utter_message(message)
        return []

